/************************************************************************/
/*                                                                      */
/* Borland Enterprise Core Objects                                      */
/*                                                                      */
/* Copyright (c) 2003-2005 Borland Software Corporation                 */
/*                                                                      */
/************************************************************************/

using System;
using Borland.Eco.DataRepresentation;
using Borland.Eco.Framework;
using Borland.Eco.UmlRt;

namespace Borland.Eco.Cache
{

	public delegate void ChangeDelegate(string message);

	/// <summary>
	/// <para>This class implements the ICache interface by simply passing
	/// all calls on to another ICache implementation
	/// It is intended for subclassing by ICache implementations that
	/// need to implement only a subset of the features of the interface.</para>
	/// <para>Override any methods you need to intercept and at the end of
	/// the overridden methods, either call the base method, or call
	/// the same method on NextCache manually. If the behaviour of the
	/// original cache is not wanted at all, then just skip calling it.</para>
	/// </summary>
	public class ChainedCacheBase: EcoSpacePart, ICache
	{
		private ICache m_nextCache;
		/// <summary>
		/// Set the "NextCache" to allow the default implementations of all
		/// interface methods to pass through the calls to another cache
		/// Setting this property is mandatory!
		/// </summary>
		public ICache NextCache
		{
			get { return m_nextCache; }
			set { m_nextCache = value; }
		}

		protected override void DoActivate()
		{
			EnsurePropertySet(NextCache, "NextCache"); // Do not localize
		}

		/// <summary>
		/// Default implementation that will only call the same method on the "NextCache"
		/// </summary>
		public virtual void SetCurrentValue(Locator locator, IStructuralFeature structuralFeature, object value)
		{
			m_nextCache.SetCurrentValue(locator, structuralFeature, value);
		}

		/// <summary>
		/// Default implementation that will only call the same method on the "NextCache"
		/// </summary>
		public virtual Locator[] GetAllLocators()
		{
			return m_nextCache.GetAllLocators();
		}

		/// <summary>
		/// Default implementation that will only call the same method on the "NextCache"
		/// </summary>
		public virtual void ApplyTranslationList(IdTranslationList idTranslationList)
		{
			m_nextCache.ApplyTranslationList(idTranslationList);
		}

		/// <summary>
		/// Default implementation that will only call the same method on the "NextCache"
		/// </summary>
		public void SetObjectId(Locator locator, ObjectId newId)
		{
			m_nextCache.SetObjectId(locator, newId);
		}

		/// <summary>
		/// Default implementation that will only call the same method on the "NextCache"
		/// </summary>
		public virtual event ValueChangedDelegate ValueChanged
		{
			add { m_nextCache.ValueChanged += value; }
			remove { m_nextCache.ValueChanged -= value; }
		}

		/// <summary>
		/// Default implementation that will only call the same method on the "NextCache"
		/// </summary>
		public virtual event LocatorEventHandler LocatorAdded
		{
			add { m_nextCache.LocatorAdded += value; }
			remove { m_nextCache.LocatorAdded -= value; }
		}

		/// <summary>
		/// Default implementation that will only call the same method on the "NextCache"
		/// </summary>
		public virtual event LocatorEventHandler DirtyChanged
		{
			add { m_nextCache.DirtyChanged += value; }
			remove { m_nextCache.DirtyChanged -= value; }
		}

		/// <summary>
		/// Default implementation that will only call the same method on the "NextCache"
		/// </summary>
		public virtual event LocatorEventHandler ExistenceChanged
		{
			add { m_nextCache.ExistenceChanged += value; }
			remove { m_nextCache.ExistenceChanged -= value; }
		}

		/// <summary>
		/// Default implementation that will only call the same method on the "NextCache"
		/// </summary>
		public virtual event CanDestroyDelegate CanDestroy
		{
			add { m_nextCache.CanDestroy += value; }
			remove { m_nextCache.CanDestroy -= value; }
		}

		/// <summary>
		/// Default implementation that will only call the same method on the "NextCache"
		/// </summary>
		public virtual Locator GetEnsuredLocatorById(ObjectId objectId)
		{
			return m_nextCache.GetEnsuredLocatorById(objectId);
		}

		/// <summary>
		/// Default implementation that will only call the same method on the "NextCache"
		/// </summary>
		public virtual Locator GetLocatorById(ObjectId objectId)
		{
			return m_nextCache.GetLocatorById(objectId);
		}

		/// <summary>
		/// Default implementation that will only call the same method on the "NextCache"
		/// </summary>
		public virtual ObjectId GetIdByLocator(Locator locator)
		{
			return m_nextCache.GetIdByLocator(locator);
		}

		/// <summary>
		/// Default implementation that will only call the same method on the "NextCache"
		/// </summary>
		public virtual Locator CreateNewObject(IClass class_)
		{
			return m_nextCache.CreateNewObject(class_);
		}

		/// <summary>
		/// Default implementation that will only call the same method on the "NextCache"
		/// </summary>
		public virtual void DestroyObject(Locator locator)
		{
			m_nextCache.DestroyObject(locator);
		}

		/// <summary>
		/// Default implementation that will only call the same method on the "NextCache"
		/// </summary>
		public virtual IClass GetUmlClass(Locator locator)
		{
			return m_nextCache.GetUmlClass(locator);
		}

		/// <summary>
		/// Default implementation that will only call the same method on the "NextCache"
		/// </summary>
		public virtual void SetExistenceState(Locator locator, Borland.Eco.Cache.ExistenceState value)
		{
			m_nextCache.SetExistenceState(locator, value);
		}

		/// <summary>
		/// Default implementation that will only call the same method on the "NextCache"
		/// </summary>
		public virtual ExistenceState GetExistenceState(Locator locator)
		{
			return m_nextCache.GetExistenceState(locator);
		}

		/// <summary>
		/// Default implementation that will only call the same method on the "NextCache"
		/// </summary>
		public virtual void SetPersistenceState(Locator locator, PersistenceState value)
		{
			m_nextCache.SetPersistenceState(locator, value);
		}

		/// <summary>
		/// Default implementation that will only call the same method on the "NextCache"
		/// </summary>
		public virtual PersistenceState GetPersistenceState(Locator locator)
		{
			return m_nextCache.GetPersistenceState(locator);
		}

		/// <summary>
		/// Default implementation that will only call the same method on the "NextCache"
		/// </summary>
		public virtual bool IsPersistent(Locator locator)
		{
			return m_nextCache.IsPersistent(locator);
		}

		/// <summary>
		/// Default implementation that will only call the same method on the "NextCache"
		/// </summary>
		public virtual bool IsDirty(Locator locator)
		{
			return m_nextCache.IsDirty(locator);
		}

		/// <summary>
		/// Default implementation that will only call the same method on the "NextCache"
		/// </summary>
		public virtual bool Contains(Locator locator)
		{
			return m_nextCache.Contains(locator);
		}

		/// <summary>
		/// Default implementation that will only call the same method on the "NextCache"
		/// </summary>
		public virtual int GetTimestamp(Locator locator)
		{
			return m_nextCache.GetTimestamp(locator);
		}

		/// <summary>
		/// Default implementation that will only call the same method on the "NextCache"
		/// </summary>
		public virtual void SetTimestamp(Locator locator, int value)
		{
			m_nextCache.SetTimestamp(locator, value);
		}

		/// <summary>
		/// Default implementation that will only call the same method on the "NextCache"
		/// </summary>
		public virtual void SetCurrentOrderNo(Locator locator, IStructuralFeature structuralFeature, int orderNo)
		{
			m_nextCache.SetCurrentOrderNo(locator, structuralFeature, orderNo);
		}

		/// <summary>
		/// Default implementation that will only call the same method on the "NextCache"
		/// </summary>
		public virtual void SetCurrentAndFetchedOrderNo(Locator locator, IStructuralFeature structuralFeature, int orderNo)
		{
			m_nextCache.SetCurrentAndFetchedOrderNo(locator, structuralFeature, orderNo);
		}

		/// <summary>
		/// Default implementation that will only call the same method on the "NextCache"
		/// </summary>
		public virtual int GetCurrentOrderNo(Locator locator, IStructuralFeature structuralFeature)
		{
			return m_nextCache.GetCurrentOrderNo(locator, structuralFeature);
		}

		/// <summary>
		/// Default implementation that will only call the same method on the "NextCache"
		/// </summary>
		public virtual PersistenceState GetMemberPersistenceState(Locator locator, IStructuralFeature structuralFeature)
		{
			return m_nextCache.GetMemberPersistenceState(locator, structuralFeature);
		}

		/// <summary>
		/// Default implementation that will only call the same method on the "NextCache"
		/// </summary>
		public virtual void SetMemberPersistenceState(Locator locator, IStructuralFeature structuralFeature, PersistenceState value)
		{
			m_nextCache.SetMemberPersistenceState(locator, structuralFeature, value);
		}

		/// <summary>
		/// Default implementation that will only call the same method on the "NextCache"
		/// </summary>
		public virtual object GetCurrentValue(Locator locator, IStructuralFeature structuralFeature)
		{
			return m_nextCache.GetCurrentValue(locator, structuralFeature);
		}

		/// <summary>
		/// Default implementation that will only call the same method on the "NextCache"
		/// </summary>
		public virtual object GetFetchedValue(Locator locator, IStructuralFeature structuralFeature)
		{
			return m_nextCache.GetFetchedValue(locator, structuralFeature);
		}

		/// <summary>
		/// Default implementation that will only call the same method on the "NextCache"
		/// </summary>
		public virtual bool GetMemberHasFetchedValue(Locator locator, IStructuralFeature structuralFeature)
		{
			return m_nextCache.GetMemberHasFetchedValue(locator, structuralFeature);
		}

		/// <summary>
		/// Default implementation that will only call the same method on the "NextCache"
		/// </summary>
		public virtual int GetFetchedOrderNo(Locator locator, IStructuralFeature structuralFeature)
		{
			return m_nextCache.GetFetchedOrderNo(locator, structuralFeature);
		}

		/// <summary>
		/// Default implementation that will only call the same method on the "NextCache"
		/// </summary>
		public virtual void SetFetchedValue(Locator locator, IStructuralFeature structuralFeature, object value)
		{
			m_nextCache.SetFetchedValue(locator, structuralFeature, value);
		}

		/// <summary>
		/// Default implementation that will only call the same method on the "NextCache"
		/// </summary>
		public virtual void SetCurrentAndFetchedValue(Locator locator, IStructuralFeature structuralFeature, object value)
		{
			m_nextCache.SetCurrentAndFetchedValue(locator, structuralFeature, value);
		}

	}
}
